# Platform Full Bundle (Laravel + PWAs)

This bundle is designed to be uploaded once to your server, then run `./install.sh`.
It will:
- Create a fresh Laravel backend via `composer create-project`
- Install required packages (Sanctum, Reverb, Filament, Google API Client)
- Overlay the business logic patch files (orders, dispatch, zones, pricing, wallets, commissions, driver bonuses, tickets, FCM, scheduled orders, private channels)
- Create 3 Next.js apps (Customer/Vendor/Driver) and overlay PWA patches (auth, API client, map picker, tracking, tickets UI, FCM web push skeleton)

## Quick start
```bash
unzip platform_full_bundle.zip
cd platform_full_bundle
chmod +x install.sh
./install.sh
```

## Configure ENV
### Backend: platform/backend/.env
- APP_URL
- DB_*
- BROADCAST_CONNECTION=reverb
- MOYASAR_API_KEY, MOYASAR_WEBHOOK_SECRET (optional)
- FIREBASE_PROJECT_ID, FIREBASE_CLIENT_EMAIL, FIREBASE_PRIVATE_KEY

### PWAs: platform/pwa-*/.env.local
- NEXT_PUBLIC_API_URL
- NEXT_PUBLIC_GOOGLE_MAPS_KEY
- NEXT_PUBLIC_REVERB_* (host/port/scheme/app key)
- NEXT_PUBLIC_FIREBASE_* (firebase web config)

## Run (dev)
Backend:
```bash
cd platform/backend
php artisan serve
php artisan queue:work --queue=push,default
php artisan reverb:start
php artisan schedule:work
```

PWAs:
```bash
cd platform/pwa-customer && npm run dev
cd platform/pwa-vendor && npm run dev
cd platform/pwa-driver && npm run dev
```
