# Backend Patch Notes
This patch overlays routes/controllers/services/events/jobs.
You must ensure these exist in your Laravel app:

1) User model:
- add `role` column to users (migration provided separately in your earlier setup)
- add relationships:
```
public function driverLocation(){ return $this->hasOne(\App\Models\DriverLocation::class, 'driver_id'); }
public function driverProfile(){ return $this->hasOne(\App\Models\DriverProfile::class, 'user_id'); }
```

2) Order model relationships:
```
public function items(){ return $this->hasMany(\App\Models\OrderItem::class); }
public function vendor(){ return $this->belongsTo(\App\Models\Vendor::class); }
public function branch(){ return $this->belongsTo(\App\Models\VendorBranch::class, 'vendor_branch_id'); }
```

3) Ticket model:
```
public function messages(){ return $this->hasMany(\App\Models\TicketMessage::class); }
```

4) Run migrations from your project (create tables for vendors/products/orders etc).
If you want, I can also generate a full migration pack for those base tables.
