<?php
namespace App\Events;

use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class OrderStatusUpdated implements ShouldBroadcastNow
{
    use InteractsWithSockets;

    public function __construct(
        public int $orderId,
        public string $status,
        public array $payload = []
    ) {}

    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('order.'.$this->orderId);
    }

    public function broadcastAs(): string
    {
        return 'order.status';
    }
}
