<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\DeviceToken;

class DeviceController extends Controller
{
    public function register(Request $request)
    {
        $data = $request->validate([
            'token' => 'required|string',
            'platform' => 'nullable|string',
        ]);

        DeviceToken::updateOrCreate(
            ['user_id'=>$request->user()->id,'token'=>$data['token']],
            ['platform'=>$data['platform'] ?? 'web']
        );

        return response()->json(['ok'=>true]);
    }
}
