<?php
namespace App\Jobs;

use App\Models\Order;
use App\Models\Vendor;
use App\Services\NotificationService;
use App\Events\OrderStatusUpdated;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class ActivateScheduledOrders implements ShouldQueue
{
    use Dispatchable, Queueable;

    public function handle(): void
    {
        $orders = Order::query()
            ->where('is_scheduled', true)
            ->where('status', 'scheduled')
            ->whereNotNull('scheduled_at')
            ->where('scheduled_at','<=', now())
            ->limit(200)
            ->get();

        if ($orders->isEmpty()) return;

        $notify = app(NotificationService::class);

        foreach ($orders as $order) {
            $order->status = 'pending';
            $order->save();

            event(new OrderStatusUpdated($order->id, $order->status));

            $vendor = Vendor::find($order->vendor_id);
            if ($vendor) {
                $notify->toUser(
                    $vendor->owner_user_id,
                    'طلب مجدول جاهز الآن',
                    "Order #{$order->id} جاهز للقبول",
                    ['type'=>'order','order_id'=>(string)$order->id]
                );
            }
        }
    }
}
