<?php
namespace App\Jobs;

use App\Models\DriverBonusRule;
use App\Models\DriverBonusPayout;
use App\Models\Order;
use App\Models\User;
use App\Services\WalletService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class ProcessDriverBonuses implements ShouldQueue
{
    use Dispatchable, Queueable;

    public function handle(): void
    {
        $start = now()->startOfWeek();
        $end = now()->endOfWeek();

        $rules = DriverBonusRule::where('is_active',true)->where('period','weekly')->orderBy('target_orders')->get();
        if ($rules->isEmpty()) return;

        $drivers = User::where('role','driver')->pluck('id');
        $wallet = app(WalletService::class);

        foreach ($drivers as $driverId) {
            $count = Order::where('driver_id',$driverId)->where('status','delivered')
                ->whereBetween('created_at', [$start, $end])->count();

            $best = null;
            foreach ($rules as $r) if ($count >= $r->target_orders) $best = $r;
            if (!$best) continue;

            $exists = DriverBonusPayout::where('driver_id',$driverId)->where('period','weekly')
                ->whereDate('period_start',$start->toDateString())
                ->whereDate('period_end',$end->toDateString())->exists();
            if ($exists) continue;

            $wallet->credit($driverId, (float)$best->bonus_amount, 'bonus', null, [
                'period'=>'weekly','start'=>$start->toDateString(),'end'=>$end->toDateString(),
                'orders'=>$count,'target'=>$best->target_orders
            ]);

            DriverBonusPayout::create([
                'driver_id'=>$driverId,'period'=>'weekly','period_start'=>$start->toDateString(),
                'period_end'=>$end->toDateString(),'orders_count'=>$count,'bonus_amount'=>$best->bonus_amount,
            ]);
        }
    }
}
