<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('coupons', function (Blueprint $t) {
            $t->id();
            $t->string('code')->unique();
            $t->enum('type', ['percent','fixed','free_delivery']);
            $t->decimal('value', 12, 2)->default(0);
            $t->timestamp('starts_at')->nullable();
            $t->timestamp('ends_at')->nullable();
            $t->unsignedInteger('max_uses')->nullable();
            $t->unsignedInteger('max_uses_per_user')->nullable();
            $t->decimal('min_subtotal', 12, 2)->nullable();
            $t->enum('scope', ['global','vendor','category','b2b_only'])->default('global');
            $t->unsignedBigInteger('vendor_id')->nullable();
            $t->boolean('active')->default(true);
            $t->timestamps();
            $t->index(['active','starts_at','ends_at']);
        });

        Schema::create('coupon_redemptions', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('coupon_id');
            $t->unsignedBigInteger('user_id');
            $t->unsignedBigInteger('order_id')->nullable();
            $t->decimal('discount_amount', 12, 2)->default(0);
            $t->timestamps();
            $t->unique(['coupon_id','user_id','order_id']);
            $t->index(['coupon_id','user_id']);
        });
    }
    public function down(): void {
        Schema::dropIfExists('coupon_redemptions');
        Schema::dropIfExists('coupons');
    }
};
