<?php
namespace App\Services;

use App\Models\VendorBranch;

class BranchService
{
    public function isOpenNow(VendorBranch $branch): bool
    {
        $dow = (int) now()->format('w');
        $h = $branch->hours->firstWhere('day_of_week', $dow);
        if (!$h || $h->is_closed) return false;
        $t = now()->format('H:i:s');
        return $t >= $h->open_time && $t <= $h->close_time;
    }
}
