<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('orders', function (Blueprint $table) {
      $table->id();
      $table->foreignId('customer_id')->constrained('users')->cascadeOnDelete();
      $table->foreignId('vendor_id')->constrained()->cascadeOnDelete();
      $table->foreignId('vendor_branch_id')->nullable();
      $table->foreignId('driver_id')->nullable()->constrained('users')->nullOnDelete();

      $table->string('type')->default('delivery');
      $table->string('status')->default('pending');

      $table->decimal('subtotal', 10, 2)->default(0);
      $table->decimal('delivery_fee', 10, 2)->default(0);
      $table->decimal('total', 10, 2)->default(0);

      $table->decimal('distance_km', 8, 2)->nullable();
      $table->json('pricing_meta')->nullable();

      $table->string('dropoff_address')->nullable();
      $table->decimal('dropoff_lat', 10, 7)->nullable();
      $table->decimal('dropoff_lng', 10, 7)->nullable();

      $table->string('otp_code')->nullable();

      $table->boolean('is_scheduled')->default(false);
      $table->timestamp('scheduled_at')->nullable();

      $table->boolean('is_settled')->default(false);

      $table->timestamps();

      $table->foreign('vendor_branch_id')->references('id')->on('vendor_branches')->nullOnDelete();
    });
  }
  public function down(): void { Schema::dropIfExists('orders'); }
};
