<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('device_tokens', function (Blueprint $table) {
      $table->id();
      $table->foreignId('user_id')->constrained()->cascadeOnDelete();
      $table->string('platform')->nullable();
      $table->text('token');
      $table->timestamps();
      $table->unique(['user_id','token']);
    });

    Schema::create('tickets', function (Blueprint $table) {
      $table->id();
      $table->foreignId('user_id')->constrained()->cascadeOnDelete();
      $table->string('subject');
      $table->string('status')->default('open');
      $table->string('priority')->default('normal');
      $table->string('category')->nullable();
      $table->unsignedBigInteger('order_id')->nullable();
      $table->foreignId('assigned_admin_id')->nullable()->constrained('users')->nullOnDelete();
      $table->timestamps();
      $table->index(['status','priority','category','order_id']);
    });

    Schema::create('ticket_messages', function (Blueprint $table) {
      $table->id();
      $table->foreignId('ticket_id')->constrained()->cascadeOnDelete();
      $table->foreignId('sender_id')->constrained('users')->cascadeOnDelete();
      $table->text('message');
      $table->json('attachments')->nullable();
      $table->timestamps();
    });

    Schema::create('payments', function (Blueprint $table) {
      $table->id();
      $table->foreignId('order_id')->constrained()->cascadeOnDelete();
      $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
      $table->string('provider')->default('moyasar');
      $table->string('status')->default('initiated');
      $table->string('provider_payment_id')->nullable();
      $table->string('invoice_id')->nullable();
      $table->decimal('amount', 12, 2);
      $table->string('currency')->default('SAR');
      $table->json('meta')->nullable();
      $table->timestamps();
      $table->index(['provider','provider_payment_id']);
    });

    Schema::create('payment_webhooks', function (Blueprint $table) {
      $table->id();
      $table->string('provider')->default('moyasar');
      $table->string('event_type')->nullable();
      $table->string('provider_payment_id')->nullable();
      $table->json('payload');
      $table->timestamps();
    });
  }

  public function down(): void {
    Schema::dropIfExists('payment_webhooks');
    Schema::dropIfExists('payments');
    Schema::dropIfExists('ticket_messages');
    Schema::dropIfExists('tickets');
    Schema::dropIfExists('device_tokens');
  }
};
