<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EnterpriseDemoSeeder extends Seeder
{
    public function run(): void
    {
        DB::table('plans')->updateOrInsert(
            ['name' => 'PRO Monthly'],
            [
                'price' => 29.00,
                'period' => 'monthly',
                'benefits' => json_encode([
                    'free_delivery' => false,
                    'delivery_discount' => 10,
                    'priority_support' => true,
                    'exclusive_offers' => true,
                ]),
                'active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]
        );

        DB::table('coupons')->updateOrInsert(
            ['code' => 'WELCOME10'],
            [
                'type' => 'percent',
                'value' => 10,
                'starts_at' => now()->subDay(),
                'ends_at' => now()->addMonths(3),
                'max_uses' => 5000,
                'max_uses_per_user' => 2,
                'min_subtotal' => 30,
                'scope' => 'global',
                'vendor_id' => null,
                'active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]
        );
    }
}
