import Link from "next/link";
import { useEffect, useState } from "react";
import { api } from "../../src/lib/api";

type Ticket = { id:number; subject:string; status:string; priority:string };

export default function Tickets() {
  const [tickets, setTickets] = useState<Ticket[]>([]);
  const [subject, setSubject] = useState("");
  const [message, setMessage] = useState("");
  const [msg, setMsg] = useState("");

  const load = async () => {
    try { setTickets(await api<Ticket[]>("/api/tickets")); } catch (e:any) { setMsg(e.message); }
  };

  useEffect(() => { load(); }, []);

  const create = async () => {
    setMsg("");
    const res = await api<any>("/api/tickets", {
      method:"POST",
      body: JSON.stringify({ subject, message, priority:"normal" })
    });
    setSubject(""); setMessage("");
    await load();
    setMsg(`Created ticket #${res.ticket.id}`);
  };

  return (
    <div style={{ maxWidth: 820, margin:"24px auto", padding:16 }}>
      <div style={{ display:"flex", justifyContent:"space-between" }}>
        <h2>Support Tickets</h2>
        <Link href="/">Home</Link>
      </div>

      {msg && <p>{msg}</p>}

      <div style={{ border:"1px solid #ddd", padding:12, borderRadius:10 }}>
        <h3>New Ticket</h3>
        <input value={subject} onChange={(e)=>setSubject(e.target.value)} placeholder="Subject"
          style={{ width:"100%", padding:10, marginTop:10 }} />
        <textarea value={message} onChange={(e)=>setMessage(e.target.value)} placeholder="Message"
          style={{ width:"100%", padding:10, marginTop:10, height:120 }} />
        <button onClick={create} style={{ marginTop:10, padding:10 }}>Create</button>
      </div>

      <h3 style={{ marginTop:20 }}>My Tickets</h3>
      {tickets.map(t => (
        <div key={t.id} style={{ border:"1px solid #ddd", padding:12, marginTop:10, borderRadius:10 }}>
          <div><b>#{t.id}</b> {t.subject}</div>
          <div>Status: {t.status} — Priority: {t.priority}</div>
          <Link href={`/tickets/${t.id}`}>Open</Link>
        </div>
      ))}
    </div>
  );
}
