import { GoogleMap, Marker, useJsApiLoader } from "@react-google-maps/api";
import { useState } from "react";

export function MapPicker({ onPick }: { onPick:(lat:number,lng:number)=>void }) {
  const { isLoaded } = useJsApiLoader({ googleMapsApiKey: process.env.NEXT_PUBLIC_GOOGLE_MAPS_KEY! });
  const [marker, setMarker] = useState<{lat:number; lng:number}>({ lat: 21.543333, lng: 39.172778 });

  if (!isLoaded) return <div>Loading map...</div>;

  return (
    <GoogleMap
      mapContainerStyle={{ width:"100%", height:360, borderRadius:12 }}
      center={marker}
      zoom={12}
      onClick={(e) => {
        const lat = e.latLng?.lat()!;
        const lng = e.latLng?.lng()!;
        setMarker({ lat, lng });
        onPick(lat, lng);
      }}
    >
      <Marker position={marker} />
    </GoogleMap>
  );
}
