import { initializeApp } from "firebase/app";
import { getMessaging, getToken as getFcmToken, onMessage } from "firebase/messaging";

export function firebaseConfig() {
  return {
    apiKey: process.env.NEXT_PUBLIC_FIREBASE_API_KEY,
    authDomain: process.env.NEXT_PUBLIC_FIREBASE_AUTH_DOMAIN,
    projectId: process.env.NEXT_PUBLIC_FIREBASE_PROJECT_ID,
    storageBucket: process.env.NEXT_PUBLIC_FIREBASE_STORAGE_BUCKET,
    messagingSenderId: process.env.NEXT_PUBLIC_FIREBASE_MESSAGING_SENDER_ID,
    appId: process.env.NEXT_PUBLIC_FIREBASE_APP_ID,
  };
}

export async function initPushAndGetToken(): Promise<string | null> {
  try {
    const app = initializeApp(firebaseConfig());
    const messaging = getMessaging(app);

    const vapidKey = process.env.NEXT_PUBLIC_FIREBASE_VAPID_KEY;
    if (!vapidKey) throw new Error("Missing NEXT_PUBLIC_FIREBASE_VAPID_KEY");

    const token = await getFcmToken(messaging, { vapidKey });
    return token || null;
  } catch (e) {
    console.error(e);
    return null;
  }
}

export function onForegroundMessage(cb: (payload: any) => void) {
  const app = initializeApp(firebaseConfig());
  const messaging = getMessaging(app);
  return onMessage(messaging, cb);
}
