import { api } from "./api";

export function startDriverTracking() {
  if (!navigator.geolocation) throw new Error("Geolocation not supported");

  const watchId = navigator.geolocation.watchPosition(async (pos) => {
    await api("/api/driver/location", {
      method: "POST",
      body: JSON.stringify({
        lat: pos.coords.latitude,
        lng: pos.coords.longitude,
        speed: pos.coords.speed ?? null,
        accuracy: pos.coords.accuracy ?? null,
        heading: pos.coords.heading ?? null,
      }),
    });
  }, console.error, { enableHighAccuracy: true, maximumAge: 2000, timeout: 10000 });

  return () => navigator.geolocation.clearWatch(watchId);
}
