import Link from "next/link";

export default function VendorLanding() {
  return (
    <div dir="rtl">
      <div className="nav">
        <div className="container navInner">
          <div className="brand">
            <img src="/assets/logo.svg" alt="Almatajer" style={{ height: 34 }} />
            <span className="pill">بوابة التاجر • عصري فاخر</span>
          </div>
          <div style={{ display:"flex", gap:10, flexWrap:"wrap" }}>
            <Link className="btn btnGhost" href="/login">دخول</Link>
            <a className="btn btnGold" href="https://app.almatajer.net" target="_self">الصفحة الرئيسية</a>
          </div>
        </div>
      </div>

      <section className="hero">
        <div className="container heroGrid">
          <div className="card cardPad">
            <h1 className="h1">انضم كتاجر في منصة المتاجر</h1>
            <div className="sub">
              استقبل الطلبات، حدّد جاهزية التحضير، وراقب التقارير — مع تسوية عمولات تلقائية.
            </div>
            <div className="row">
              <Link className="btn btnGold" href="/login">دخول التاجر</Link>
              <a className="btn btnGhost" href="https://app.almatajer.net/tickets" target="_self">تواصل مع الدعم</a>
            </div>

            <div className="kpis" dir="rtl">
              <div className="kpi"><b>إشعارات فورية</b><span>عند وصول طلب أو تحديث الحالة</span></div>
              <div className="kpi"><b>لوحة طلبات</b><span>قبول/رفض + إدارة سير العمل</span></div>
              <div className="kpi"><b>تسوية العمولات</b><span>Wallet للمتجر وعمولات المنصة</span></div>
            </div>
          </div>

          <div className="card">
            <img className="heroImg" src="/assets/hero-2.png" alt="hero" />
          </div>
        </div>
      </section>
    </div>
  );
}
