import { useState } from "react";
import { api } from "../src/lib/api";
import { saveAuth } from "../src/lib/auth";
import { useRouter } from "next/router";

export default function Login() {
  const [email, setEmail] = useState("admin@demo.com");
  const [password, setPassword] = useState("password");
  const [err, setErr] = useState<string | null>(null);
  const router = useRouter();

  const submit = async () => {
    setErr(null);
    try {
      const res = await api<{ token: string; user: any }>("/api/auth/login", {
        method: "POST",
        body: JSON.stringify({ email, password }),
      });
      saveAuth(res.token, res.user.role);
      router.push("/");
    } catch (e: any) {
      setErr(e.message);
    }
  };

  return (
    <div style={{ maxWidth: 420, margin: "40px auto", padding: 16 }}>
      <h2>Login</h2>
      <input value={email} onChange={(e)=>setEmail(e.target.value)} placeholder="email"
        style={{ width:"100%", padding:10, marginTop:10 }} />
      <input value={password} onChange={(e)=>setPassword(e.target.value)} placeholder="password" type="password"
        style={{ width:"100%", padding:10, marginTop:10 }} />
      <button onClick={submit} style={{ width:"100%", padding:12, marginTop:12 }}>Login</button>
      {err && <p style={{ color:"red" }}>{err}</p>}
      <p style={{ marginTop: 10, fontSize: 12 }}>
        Demo: admin@demo.com / vendor@demo.com / driver1@demo.com (password)
      </p>
    </div>
  );
}
